<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('address_id', 'client_id', 'total_price', 'delivery_cost', 'status', 'phone', 'payment_method', 'note');

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

}