<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('name', 'slug', 'description', 'price', 'offer_percent', 'ordered_number', 'level', 'rate');

	public function categories()
	{
		return $this->belongsToMany('App\Models\Category');
	}

	public function orders()
	{
		return $this->belongsToMany('App\Models\Order');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client');
	}

	public function complaints()
	{
		return $this->belongsToMany('App\Models\ComplaintReason');
	}

	public function specifications()
	{
		return $this->hasMany('App\Models\Specification');
	}

	public function sizes()
	{
		return $this->hasMany('App\Models\Size');
	}

	public function reviews()
	{
		return $this->hasMany('App\Models\Review');
	}

}