<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title')->index();
			$table->text('description')->nullable();
			$table->boolean('is_enabled')->nullable()->default(false);
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}