<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentFieldsTable extends Migration {

	public function up()
	{
		Schema::create('content_fields', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->integer('content_id')->nullable()->index();
			$table->string('name')->nullable()->index();
			$table->string('type')->nullable()->index();
			$table->integer('length')->nullable();
			$table->boolean('is_required')->nullable()->default(false);
			$table->boolean('is_multiple')->nullable()->default(false);
			$table->boolean('is_relation')->nullable()->default(false);
			$table->string('relation_with')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('content_fields');
	}
}