<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentValuesTable extends Migration {

	public function up()
	{
		Schema::create('content_values', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->integer('content_id')->unsigned()->nullable()->index();
			$table->json('value')->nullable();
			$table->string('slug')->nullable()->index();
		});
	}

	public function down()
	{
		Schema::drop('content_values');
	}
}