<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContentsTable extends Migration {

	public function up()
	{
		Schema::create('contents', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('site_id')->unsigned()->nullable();
			$table->string('title')->nullable()->index();
			$table->string('slug')->nullable()->index();
			$table->text('description')->nullable();
			$table->string('status')->nullable()->default('0');
			$table->integer('index')->nullable()->default('0');
			$table->json('fields')->nullable();
			$table->json('data_extra')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contents');
	}
}