<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('uuid')->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('email')->index();
			$table->string('name')->index();
			$table->boolean('is_enabled')->default(false);
			$table->string('password');
			$table->string('remember_token')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}