<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFilesTable extends Migration {

	public function up()
	{
		Schema::create('files', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid')->unique();
			$table->string('url_real')->nullable()->index();
			$table->string('url')->nullable();
			$table->string('extension')->nullable();
			$table->double('size')->nullable();
			$table->string('storage', 63)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('files');
	}
}