<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressesTable extends Migration {

	public function up()
	{
		Schema::create('user_addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('family_name');
			$table->string('floor_number')->nullable();
			$table->text('charge_note')->nullable();
			$table->integer('client_id')->unsigned();
			$table->integer('region_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('user_addresses');
	}
}