<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('state_ar');
			$table->string('state_en');
			$table->string('sub_cost');
			$table->string('charge_fees');
			$table->string('total_price');
			$table->double('commission');
			$table->string('net_price');
			$table->integer('client_id')->unsigned();
			$table->integer('store_id')->unsigned();
			$table->integer('coupon_id')->unsigned();
			$table->integer('payment_method_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}