<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_details()
    {
        return $this->hasOne('UserProfile');
    }

    public function user_organizations()
    {
        return $this->hasMany('UserOrganization');
    }

}