<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserOrganization extends Model 
{

    protected $table = 'user_organizations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function organizations()
    {
        return $this->belongsTo('Organization', 'organization_id');
    }

}