<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrganizationsTable extends Migration {

	public function up()
	{
		Schema::create('organizations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('organizationName', 50);
			$table->string('city', 50);
			$table->string('state', 50);
			$table->integer('zipcode');
			$table->string('officePhone', 20);
			$table->string('lat', 20);
			$table->string('long', 20);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('organizations');
	}
}