<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserOrganizationsTable extends Migration {

	public function up()
	{
		Schema::create('user_organizations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('organization_id');
			$table->enum('status', array(''0'', ''1''));
			$table->enum('isprimary', array(''0'', ''1''));
			$table->enum('role', array(''0'', ''1'', ''2'', ''3'', ''4''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('user_organizations');
	}
}