<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Organization extends Eloquent {

	protected $table = 'organizations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function customers()
	{
		return $this->hasMany('Customer', 'organization_id');
	}

	public function organization_details()
	{
		return $this->hasOne('OrganizationDetails', 'organization_id');
	}

}