<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class UserOrganization extends Eloquent {

	protected $table = 'user_organizations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsTo('User', 'user_id');
	}

	public function organizations()
	{
		return $this->belongsTo('Organization', 'organization_id');
	}

}