<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriversTable extends Migration {

	public function up()
	{
		Schema::create('drivers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('vehicle_id');
			$table->enum('shiftStatus', array(''0'', ''1''));
			$table->string('lat', 20);
			$table->string('long', 20);
			$table->text('orderLists');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('drivers');
	}
}