<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsItemsTable extends Migration {

	public function up()
	{
		Schema::create('requests_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('request_id')->unsigned();
			$table->integer('seller_id')->nullable();
			$table->text('description')->nullable();
			$table->integer('quantity')->nullable();
			$table->double('price')->nullable();
			$table->double('total_price')->nullable();
			$table->integer('status')->nullable();
			$table->timestamps();
			$table->integer('email')->nullable();
			$table->string('date_de_livraison', 50)->nullable()->default('0000-00-00');
		});
	}

	public function down()
	{
		Schema::drop('requests_items');
	}
}