<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function requests()
	{
		return $this->belongsToMany('Vanguard\User');
	}

	public function user()
	{
		return $this->belongsTo('Vanguard\User');
	}

}