<?php

namespace Vanguard;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'Users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brands()
	{
		return $this->belongsToMany('Vanguard\Brand');
	}

	public function requests()
	{
		return $this->hasMany('Vanguard\User');
	}

	public function orders()
	{
		return $this->hasMany('\Order');
	}

}