<?php

namespace API;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Conversation extends Model 
{

    protected $table = 'conversation';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'seller_id', 'last_message', 'read');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function seller()
    {
        return $this->belongsTo('User', 'seller_id');
    }

    public function messages()
    {
        return $this->hasMany('Message', 'conversation_id');
    }

}