<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'item';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'city_id', 'category_id', 'car_id', 'car_model_id', 'name', 'description', 'price', 'negotiable', 'expired', 'latitude', 'longitude', 'mobile', 'facebook', 'twitter', 'whatsapp', 'website', 'allow_message', 'delivery', 'type', 'year');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

    public function city()
    {
        return $this->belongsTo('City', 'city_id');
    }

    public function category()
    {
        return $this->belongsTo('Category', 'category_id');
    }

    public function car()
    {
        return $this->belongsTo('Car', 'car_id');
    }

    public function car_model()
    {
        return $this->belongsTo('CarModel', 'car_model_id');
    }

    public function payments()
    {
        return $this->belongsToMany('Payment', 'item_payment', 'item_id', 'payment_id');
    }

}