<?php

namespace Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Message extends Model 
{

    protected $table = 'message';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('conversation_id', 'is_seller', 'message', 'read');

    public function conversation()
    {
        return $this->belongsTo('Conversation', 'conversation_id');
    }

}