<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInspectionCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('inspection_categories', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('name', 100)->index();
			$table->tinyInteger('all_properties')->default('1');
			$table->string('state', 10)->nullable()->index()->default('NULL');
			$table->string('property_type', 100)->index();
			$table->tinyInteger('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('inspection_categories');
	}
}