<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInspectionReportsTable extends Migration {

	public function up()
	{
		Schema::create('inspection_reports', function(Blueprint $table) {
			$table->increments('id', true);
			$table->integer('house_id')->index();
			$table->integer('submitted_by')->index();
			$table->string('inspection_type', 50)->index()->default('general_inspection');
			$table->string('grade')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('inspection_reports');
	}
}