<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyHasImagesTable extends Migration {

	public function up()
	{
		Schema::create('property_has_images', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->bigInteger('property_id')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('property_has_images');
	}
}