<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePropertyRejectionReasonsTable extends Migration {

	public function up()
	{
		Schema::create('property_rejection_reasons', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('property_id')->unsigned();
			$table->bigInteger('rejection_reason_id')->unsigned();
			$table->bigInteger('created_by')->unsigned();
			$table->bigInteger('updated_by')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('note', 500);
		});
	}

	public function down()
	{
		Schema::drop('property_rejection_reasons');
	}
}