<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class PropertiesFeature extends Eloquent {

	protected $table = 'properties_features';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function products()
	{
		return $this->belongsToMany('PropertyFeature', 'property_feature_id');
	}

	public function room_type()
	{
		return $this->belongsTo('App\Models\PropertyType', 'room_type_id');
	}

}