<?php

namespace App;

class CoiPegawai extends Eloquent {

	protected $table = 'coi_pegawai';
	public $timestamps = true;

	public function user()
	{
		return $this->belongsTo('App\User', 'nip_pegawai', 'nip');
	}

	public function putusanAtasan()
	{
		return $this->belongsTo('App\Putusan', 'putusan_atasan_id', 'id');
	}

	public function rekomendasiPutusan()
	{
		return $this->belongsTo('App\Putusan', 'rekomendasi_putusan_id', 'id');
	}

	public function klasifikasi()
	{
		return $this->belongsTo('App\Klasifikasi', 'klasifikasi_id', 'id');
	}

	public function evaluasiCoi()
	{
		return $this->belongsTo('App\EvaluasiCoi', 'evaluasi_id', 'id');
	}

	public function atasan()
	{
		return $this->belongsTo('App\User', 'nip_atasan', 'nip');
	}

	public function historyCoi()
	{
		return $this->hasMany('App\HistoryCoi', 'coi_id', 'id');
	}

	public function lastStatusCoi()
	{
		return $this->belongsTo('App\StatusCoi', 'last_status_id', 'id');
	}

	public function businessArea()
	{
		return $this->belongsTo('App\BusinessArea', 'business_area', 'business_area');
	}

	public function companyCode()
	{
		return $this->belongsTo('App\CompanyCode', 'company_code', 'company_code');
	}

	public function divKpt()
	{
		return $this->belongsTo('App\User', 'divkpt_id', 'id');
	}

}