<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('survey_id')->unsigned();
			$table->string('title');
			$table->string('type');
			$table->text('options')->nullable();
			$table->boolean('filterable');
			$table->integer('order');
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}