<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResourcesTable extends Migration {

	public function up()
	{
		Schema::create('resources', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('resources_category_id')->unsigned();
			$table->string('name');
			$table->decimal('price')->default('00.0');
			$table->string('description');
			$table->tinyInteger('status')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('resources');
	}
}