<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('invoice_id')->unsigned();
			$table->bigInteger('payment_method_id')->unsigned();
			$table->decimal('amount', 12,2);
			$table->string('remarks');
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}