<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAllowanceTable extends Migration {

	public function up()
	{
		Schema::create('allowance', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('type_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->double('amount')->nullable();
			$table->enum('calculation_method', array('fixed', 'percentage'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('allowance');
	}
}