<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('payroll_employee', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('payroll_id')->nullable();
			$table->double('main_salary')->nullable();
			$table->double('allowances')->nullable();
			$table->double('deductions')->nullable();
			$table->double('bonus')->nullable();
			$table->double('total')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payroll_employee');
	}
}