<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePayrollTable extends Migration {

	public function up()
	{
		Schema::create('payroll', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->nullable();
			$table->integer('mall_id')->nullable();
			$table->integer('account_id')->nullable();
			$table->enum('month', array('1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'))->nullable();
			$table->integer('year')->nullable();
			$table->integer('employee_number')->nullable();
			$table->double('total')->nullable();
			$table->datetime('payment_date')->nullable();
			$table->text('description_en')->nullable();
			$table->text('description_ar')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('payroll');
	}
}