<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('phone_type_id')->references('id')->on('phone_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_informations', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_venue_informations', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_venue_types', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_venue_types', function(Blueprint $table) {
			$table->foreign('venue_type_id')->references('id')->on('venue_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_facility_amenities', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_facility_amenities', function(Blueprint $table) {
			$table->foreign('facility_amenity_id')->references('id')->on('facility_amenities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_indoor_function_amenities', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_indoor_function_amenities', function(Blueprint $table) {
			$table->foreign('indoor_function_amenity_id')->references('id')->on('indoor_function_amenities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_facility_restrictions', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('service_venue_menu_choices', function(Blueprint $table) {
			$table->foreign('service_information_id')->references('id')->on('service_informations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('insurances', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_service_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_phone_type_id_foreign');
		});
		Schema::table('service_informations', function(Blueprint $table) {
			$table->dropForeign('service_informations_user_id_foreign');
		});
		Schema::table('service_venue_informations', function(Blueprint $table) {
			$table->dropForeign('service_venue_informations_service_information_id_foreign');
		});
		Schema::table('service_venue_types', function(Blueprint $table) {
			$table->dropForeign('service_venue_types_service_information_id_foreign');
		});
		Schema::table('service_venue_types', function(Blueprint $table) {
			$table->dropForeign('service_venue_types_venue_type_id_foreign');
		});
		Schema::table('service_facility_amenities', function(Blueprint $table) {
			$table->dropForeign('service_facility_amenities_service_information_id_foreign');
		});
		Schema::table('service_facility_amenities', function(Blueprint $table) {
			$table->dropForeign('service_facility_amenities_facility_amenity_id_foreign');
		});
		Schema::table('service_indoor_function_amenities', function(Blueprint $table) {
			$table->dropForeign('service_indoor_function_amenities_service_information_id_foreign');
		});
		Schema::table('service_indoor_function_amenities', function(Blueprint $table) {
			$table->dropForeign('service_indoor_function_amenities_indoor_function_amenity_id_foreign');
		});
		Schema::table('service_facility_restrictions', function(Blueprint $table) {
			$table->dropForeign('service_facility_restrictions_service_information_id_foreign');
		});
		Schema::table('service_venue_menu_choices', function(Blueprint $table) {
			$table->dropForeign('service_venue_menu_choices_service_information_id_foreign');
		});
		Schema::table('contract_payments', function(Blueprint $table) {
			$table->dropForeign('contract_payments_user_id_foreign');
		});
		Schema::table('insurances', function(Blueprint $table) {
			$table->dropForeign('insurances_profile_id_foreign');
		});
	}
}