<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Profile extends Eloquent {

	protected $table = 'profiles';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function service()
	{
		return $this->belongsTo('App/Models\Service');
	}

	public function PhoneType()
	{
		return $this->belongsTo('App/Models\PhoneType');
	}

}