<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLogsTable extends Migration {

	public function up()
	{
		Schema::create('logs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('url');
			$table->string('method', 16);
			$table->ipAddress('ip')->nullable();
			$table->string('client_ip', 45)->nullable();
			$table->json('post_params')->nullable();
			$table->string('query_string')->nullable();
			$table->smallInteger('response_status')->unsigned();
			$table->json('response_body')->nullable();
			$table->json('response_headers')->nullable();
			$table->integer('loggable_id')->unsigned()->nullable();
			$table->string('loggable_type')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('logs');
	}
}