<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('order_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('professional_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credentials', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('endpoints', function(Blueprint $table) {
			$table->foreign('credential_id')->references('id')->on('credentials')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('order_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('webhooks', function(Blueprint $table) {
			$table->foreign('endpoint_id')->references('id')->on('endpoints')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('webhooks', function(Blueprint $table) {
			$table->foreign('event_id')->references('id')->on('events')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('webhook_requests', function(Blueprint $table) {
			$table->foreign('webhook_id')->references('id')->on('webhooks')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_customer_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_category_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_professional_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_user_id_foreign');
		});
		Schema::table('messages', function(Blueprint $table) {
			$table->dropForeign('messages_order_id_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_order_id_foreign');
		});
		Schema::table('credentials', function(Blueprint $table) {
			$table->dropForeign('credentials_user_id_foreign');
		});
		Schema::table('endpoints', function(Blueprint $table) {
			$table->dropForeign('endpoints_credential_id_foreign');
		});
		Schema::table('order_categories', function(Blueprint $table) {
			$table->dropForeign('order_categories_parent_id_foreign');
		});
		Schema::table('webhooks', function(Blueprint $table) {
			$table->dropForeign('webhooks_endpoint_id_foreign');
		});
		Schema::table('webhooks', function(Blueprint $table) {
			$table->dropForeign('webhooks_event_id_foreign');
		});
		Schema::table('webhook_requests', function(Blueprint $table) {
			$table->dropForeign('webhook_requests_webhook_id_foreign');
		});
	}
}