<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'email');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

	public function messages()
	{
		return $this->morphMany('App\Models\Message');
	}

	public function logs()
	{
		return $this->morphMany('App\Models\Log');
	}

	public function events()
	{
		return $this->morphMany('App\Models\Event');
	}

}