<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function order()
	{
		return $this->belongsTo('App\Models\Order');
	}

	public function logs()
	{
		return $this->morphMany('App\Models\Log');
	}

	public function events()
	{
		return $this->morphMany('App\Models\Event');
	}

}