<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Webhooks extends Eloquent {

	protected $table = 'webhooks';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function endpoint()
	{
		return $this->belongsTo('App\Models\Endpoint');
	}

	public function requests()
	{
		return $this->hasMany('App\Models\WebhookRequest');
	}

	public function event()
	{
		return $this->belongsTo('App\Models\Event');
	}

}