<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Vehicle extends Model 
{

    protected $table = 'vehicles';
    public $timestamps = true;

    public function owner()
    {
        return $this->belongsTo('Owner');
    }

    public function manufacturer()
    {
        return $this->hasOne('Manufacturer');
    }

    public function transmission()
    {
        return $this->hasOne('Transmission');
    }

    public function usage()
    {
        return $this->hasOne('Usage');
    }

}