<?php

namespace Jiri;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student extends Model 
{

    protected $table = 'students';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email');

    public function meetings()
    {
        return $this->hasMany('Impression');
    }

    public function implementations()
    {
        return $this->hasMany('Implementation');
    }

    public function projects()
    {
        return $this->belongsToMany('Project');
    }

}