<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVariantsTable extends Migration {

	public function up()
	{
		Schema::create('variants', function(Blueprint $table) {
			$table->integer('id', true);
			$table->integer('vehicle_id')->unsigned();
			$table->string('name', 100);
			$table->string('battery', 100);
			$table->string('range', 100);
			$table->string('charge_time', 100);
			$table->string('motor', 100);
			$table->string('riding_modes', 100);
			$table->string('max_loading_capacity', 100);
			$table->string('kerb_weight', 100);
			$table->string('brakes_type', 100);
			$table->string('storage_capacity', 100);
			$table->timestamp('created_at');
			$table->timestamp('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('variants');
	}
}