<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderHandleTable extends Migration {

	public function up()
	{
		Schema::create('order_handle', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->text('client')->nullable();
			$table->text('note')->nullable();
			$table->text('processes')->nullable();
			$table->boolean('is_active')->default(1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_handle');
	}
}