<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('third_base', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('third_coefficients', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('third_coefficients', function(Blueprint $table) {
			$table->foreign('third_base_id')->references('id')->on('third_base')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('third_finances', function(Blueprint $table) {
			$table->foreign('third_base_id')->references('id')->on('third_base')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('third_finances', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('insurance_id')->references('id')->on('insurances')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_handle', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_handle', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_Price', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_Price', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->foreign('insurance_id')->references('id')->on('insurances')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_service', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_service', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bodies', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('bodies', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('body_coverages', function(Blueprint $table) {
			$table->foreign('body_id')->references('id')->on('bodies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('body_discounts', function(Blueprint $table) {
			$table->foreign('body_id')->references('id')->on('bodies')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('body_uses', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fires', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fires', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('travel_plan_id')->references('id')->on('travel_plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->foreign('travel_group_id')->references('id')->on('travel_groups')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('healths', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('healths', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('responsibles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('responsibles', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('car_usages')->references('id')->on('car_usages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('car_id')->references('id')->on('car_usages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('model_id')->references('id')->on('car_usages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->foreign('last_brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_credits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_credits', function(Blueprint $table) {
			$table->foreign('user_creator')->references('id')->on('Users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('Lifes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('Users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Lifes', function(Blueprint $table) {
			$table->foreign('insurance_id')->references('id')->on('insurances')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('user_addresses', function(Blueprint $table) {
			$table->dropForeign('user_addresses_user_id_foreign');
		});
		Schema::table('third_base', function(Blueprint $table) {
			$table->dropForeign('third_base_user_id_foreign');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->dropForeign('thirds_user_id_foreign');
		});
		Schema::table('thirds', function(Blueprint $table) {
			$table->dropForeign('thirds_brand_id_foreign');
		});
		Schema::table('third_coefficients', function(Blueprint $table) {
			$table->dropForeign('third_coefficients_brand_id_foreign');
		});
		Schema::table('third_coefficients', function(Blueprint $table) {
			$table->dropForeign('third_coefficients_third_base_id_foreign');
		});
		Schema::table('third_finances', function(Blueprint $table) {
			$table->dropForeign('third_finances_third_base_id_foreign');
		});
		Schema::table('third_finances', function(Blueprint $table) {
			$table->dropForeign('third_finances_brand_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_insurance_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_brand_id_foreign');
		});
		Schema::table('order_handle', function(Blueprint $table) {
			$table->dropForeign('order_handle_order_id_foreign');
		});
		Schema::table('order_handle', function(Blueprint $table) {
			$table->dropForeign('order_handle_user_id_foreign');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->dropForeign('order_agent_order_id_foreign');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->dropForeign('order_agent_user_id_foreign');
		});
		Schema::table('order_agent', function(Blueprint $table) {
			$table->dropForeign('order_agent_agent_id_foreign');
		});
		Schema::table('order_Price', function(Blueprint $table) {
			$table->dropForeign('order_Price_order_id_foreign');
		});
		Schema::table('order_Price', function(Blueprint $table) {
			$table->dropForeign('order_Price_brand_id_foreign');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->dropForeign('order_input_order_id_foreign');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->dropForeign('order_input_insurance_id_foreign');
		});
		Schema::table('order_input', function(Blueprint $table) {
			$table->dropForeign('order_input_brand_id_foreign');
		});
		Schema::table('order_service', function(Blueprint $table) {
			$table->dropForeign('order_service_order_id_foreign');
		});
		Schema::table('order_service', function(Blueprint $table) {
			$table->dropForeign('order_service_user_id_foreign');
		});
		Schema::table('bodies', function(Blueprint $table) {
			$table->dropForeign('bodies_user_id_foreign');
		});
		Schema::table('bodies', function(Blueprint $table) {
			$table->dropForeign('bodies_brand_id_foreign');
		});
		Schema::table('body_coverages', function(Blueprint $table) {
			$table->dropForeign('body_coverages_body_id_foreign');
		});
		Schema::table('body_discounts', function(Blueprint $table) {
			$table->dropForeign('body_discounts_body_id_foreign');
		});
		Schema::table('body_uses', function(Blueprint $table) {
			$table->dropForeign('body_uses_brand_id_foreign');
		});
		Schema::table('fires', function(Blueprint $table) {
			$table->dropForeign('fires_user_id_foreign');
		});
		Schema::table('fires', function(Blueprint $table) {
			$table->dropForeign('fires_brand_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_user_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_brand_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_travel_plan_id_foreign');
		});
		Schema::table('Travels', function(Blueprint $table) {
			$table->dropForeign('Travels_travel_group_id_foreign');
		});
		Schema::table('healths', function(Blueprint $table) {
			$table->dropForeign('healths_user_id_foreign');
		});
		Schema::table('healths', function(Blueprint $table) {
			$table->dropForeign('healths_brand_id_foreign');
		});
		Schema::table('responsibles', function(Blueprint $table) {
			$table->dropForeign('responsibles_user_id_foreign');
		});
		Schema::table('responsibles', function(Blueprint $table) {
			$table->dropForeign('responsibles_brand_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_user_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_car_usages_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_car_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_model_id_foreign');
		});
		Schema::table('user_cars', function(Blueprint $table) {
			$table->dropForeign('user_cars_last_brand_id_foreign');
		});
		Schema::table('user_credits', function(Blueprint $table) {
			$table->dropForeign('user_credits_user_id_foreign');
		});
		Schema::table('user_credits', function(Blueprint $table) {
			$table->dropForeign('user_credits_user_creator_foreign');
		});
		Schema::table('Lifes', function(Blueprint $table) {
			$table->dropForeign('Lifes_user_id_foreign');
		});
		Schema::table('Lifes', function(Blueprint $table) {
			$table->dropForeign('Lifes_insurance_id_foreign');
		});
	}
}