<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('Users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('fname')->nullable();
			$table->string('lname')->nullable();
			$table->string('password')->nullable();
			$table->string('email')->nullable();
			$table->tinyInteger('email_verify')->default('0');
			$table->string('activation_code');
			$table->string('mobile')->nullable();
			$table->string('type')->nullable();
			$table->string('activation_token');
			$table->string('token_type')->nullable();
			$table->longText('api_token')->nullable();
			$table->datetime('expires_at')->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->tinyInteger('is_active')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('Users');
	}
}