<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAvailableDownloadsTable extends Migration {

	public function up()
	{
		Schema::create('available_downloads', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->index();
			$table->string('product_type', 32);
			$table->integer('product_id')->unsigned()->index();
			$table->integer('item_order_id')->unique()->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('available_downloads');
	}
}