<?php

namespace Dvlop;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AvailableDownload extends Model 
{

    protected $table = 'available_downloads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'product_type', 'product_id', 'item_order_id');

    public function orderItem()
    {
        return $this->belongsTo('OrderItem');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}